import http from 'k6/http';
import { check, sleep } from 'k6';

export let options = {
    stages: [
        { duration: '160s', target: 20000 }, // Ramp-up to 20 VUs
        { duration: '2s', target: 20000 },  // Stay at 20 VUs for 1 minute
        { duration: '10s', target: 0 },  // Ramp-down to 0 VUs
    ],
};

export default function () {
	let res = http.get('https://test.com/api');
    check(res, {
        'status is 200': (r) => r.status === 200,
    });
    sleep(1);
}

